#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_TestingMethod : BaseTest
	{
		BOL.TestingMethod _tstMethod;
		DataRow _drMethod = null;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._drMethod = UnitTestUtil.RunSQLGetDataRow("SELECT * FROM dbo.TestingMethod WHERE TestingMethodCode = '"+Common.Utility.GetTestingMethodCodeFromEnum(Common.TestingMethod.Gel).ToString()+"'");
				//
				this.RefreshData = false;
			}
			//
			this._tstMethod = new BOL.TestingMethod(Common.Utility.GetTestingMethodCodeFromEnum(Common.TestingMethod.Gel).ToString());
		}

		[Test]
		public void TestingMethodCode_Pass()
		{
			Assert.AreEqual(this._drMethod[TABLES.TestingMethod.TestingMethodCode].ToString(),this._tstMethod.TestingMethodCode,"TestingMethodCode");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestingMethodCode_Fail()
		{
		}

		[Test]
		public void TestingMethodText_Pass()
		{
			Assert.AreEqual(this._drMethod[TABLES.TestingMethod.TestingMethodText].ToString(),this._tstMethod.TestingMethodText,"TestingMethodText");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestingMethodText_Fail()
		{
		}

		[Test]
		public void SortColumn_Pass()
		{
			Assert.AreEqual(Convert.ToInt16(this._drMethod[TABLES.TestingMethod.SortColumn]),this._tstMethod.SortColumn,"SortColumn");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SortColumn_Fail()
		{
		}

		[Test]
		public void LastUpdateDate_Pass()
		{
			Assert.AreEqual(this._drMethod[TABLES.TestingMethod.LastUpdateDate].ToString(),this._tstMethod.LastUpdateDate.ToString(),"LastUpdateDate");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LastUpdateDate_Fail()
		{
		}

		[Test]
		public void LastUpdateUser_Pass()
		{
			Assert.AreEqual(this._drMethod[TABLES.TestingMethod.LastUpdateUser].ToString(),this._tstMethod.LastUpdateUser,"LastUpdateUser");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LastUpdateUser_Fail()
		{
		}

		[Test]
		public void RowVersion_Pass()
		{
			Assert.AreEqual(this._drMethod[TABLES.TestingMethod.RowVersion].ToString(),this._tstMethod.RowVersion.ToString(),"RowVersion");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RowVersion_Fail()
		{
		}

		[Test]
		public void GetTestingMethod_Pass()
		{
			BOL.TestingMethod tst = BOL.TestingMethod.GetTestingMethod(this._tstMethod.TestingMethodCode);
			Assert.AreEqual(tst.TestingMethodCode,this._tstMethod.TestingMethodCode,"TestingMethodCode");
			Assert.AreEqual(tst.TestingMethodText,this._tstMethod.TestingMethodText,"TestingMethodText");
			Assert.AreEqual(tst.SortColumn,this._tstMethod.SortColumn,"SortColumn");
		}

		[Test]
        [ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetTestingMethod_Fail()
		{
			BOL.TestingMethod tst = BOL.TestingMethod.GetTestingMethod("!");
			Assert.AreEqual(tst.TestingMethodCode,this._tstMethod.TestingMethodCode,"TestingMethodCode");
			Assert.AreEqual(tst.TestingMethodText,this._tstMethod.TestingMethodText,"TestingMethodText");
			Assert.AreEqual(tst.SortColumn,this._tstMethod.SortColumn,"SortColumn");
		}

		[Test]
		public void Ctor_Pass()
		{
			BOL.TestingMethod tst = BOL.TestingMethod.GetTestingMethod(this._tstMethod.TestingMethodCode);
			Assert.AreEqual(tst.TestingMethodCode,this._tstMethod.TestingMethodCode,"TestingMethodCode");
			Assert.AreEqual(tst.TestingMethodText,this._tstMethod.TestingMethodText,"TestingMethodText");
			Assert.AreEqual(tst.SortColumn,this._tstMethod.SortColumn,"SortColumn");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void Ctor_Fail()
		{
			BOL.TestingMethod tst = BOL.TestingMethod.GetTestingMethod("!");
			Assert.AreEqual(tst.TestingMethodCode,this._tstMethod.TestingMethodCode,"TestingMethodCode");
			Assert.AreEqual(tst.TestingMethodText,this._tstMethod.TestingMethodText,"TestingMethodText");
			Assert.AreEqual(tst.SortColumn,this._tstMethod.SortColumn,"SortColumn");
		}
	}
}
#endif
